import subprocess
import json
import URInterface
import URRouterInfo
import os
def set_snmp_value(oid, value, ip, community='public', version='2c'):
    command = [
        'snmpset',
        '-v', version,
        '-c', community,
        ip,
        oid,
        's',  # Type 's' for STRING
        str(value)
    ]

    try:
        result = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        stdout, stderr = result.communicate()

        if result.returncode == 0:
            print("SNMP set command executed successfully.")
            print("Output:", stdout)
        else:
            print("SNMP set command failed.")
            print("Error:", stderr)
    except Exception as e:
        print("An error occurred: {}".format(e))

do = URRouterInfo.get_do_output_info()
print(do)
flag_file = '/sys/class/gpio/gpio54/value'
if not os.path.exists(flag_file):
    os.system('echo 54 > /sys/class/gpio/export')
    with open(flag_file, 'w') as file:
        file.write('initialized')
with open('/sys/class/gpio/gpio54/value', 'r') as file:
    di_value = file.read().strip()

print(di_value)
set_snmp_value('1.3.6.1.2.1.1.5.0', di_value, '192.168.45.8')
set_snmp_value('1.3.6.1.2.1.1.6.0', do, '192.168.45.8')
#set OID and snmp server ip
